## Contributing to RP2040_SD

### Reporting Bugs

Please report bugs in [RP2040_SD Issues](https://github.com/khoih-prog/RP2040_SD/issues) if you find them.

However, before reporting a bug please check through the following:

* [Existing Open Issues](https://github.com/khoih-prog/RP2040_SD/issues) - someone might have already encountered this.

If you don't find anything, please [open a new issue](https://github.com/khoih-prog/RP2040_SD/issues/new).

### How to submit a bug report

Please ensure to specify the following:

* Arduino IDE version (e.g. 1.8.16) or Platform.io version
* `Arduino mbed_rp2040` Core Version (e.g. Arduino mbed_rp2040 core v2.5.2) or `RP2040` Core Version (e.g. RP2040 core v1.9.5)
* `RP2040` Board type (e.g. Nano_RP2040_Connect, RASPBERRY_PI_PICO, ADAFRUIT_FEATHER_RP2040, GENERIC_RP2040, etc.)
* Contextual information (e.g. what you were trying to achieve)
* Simplest possible steps to reproduce
* Anything that might be relevant in your opinion, such as:
  * Operating system (Windows, Ubuntu, etc.) and the output of `uname -a`
  * Network configuration


### Example

```
Arduino IDE version: 1.8.16
Arduino mbed_rp2040 core v2.5.2
RASPBERRY_PI_PICO board
OS: Ubuntu 20.04 LTS
Linux xy-Inspiron-3593 5.4.0-86-generic #97-Ubuntu SMP Fri Sep 17 19:19:40 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux

Context:
I encountered a crash while using TimerInterrupt.

Steps to reproduce:
1. ...
2. ...
3. ...
4. ...
```

### Sending Feature Requests

Feel free to post feature requests. It's helpful if you can explain exactly why the feature would be useful.

There are usually some outstanding feature requests in the [existing issues list](https://github.com/khoih-prog/RP2040_SD/issues?q=is%3Aopen+is%3Aissue+label%3Aenhancement), feel free to add comments to them.

### Sending Pull Requests

Pull Requests with changes and fixes are also welcome!
